package cn.com.duiba.message.service.api.param;

import java.io.Serializable;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 微网通联，回调
 * Created by gyf .
 * 2020/8/18 .
 */
@Data
@NoArgsConstructor
public class SmsUmcParam implements Serializable {

    private static final long serialVersionUID = 2504420601410802427L;

    /**
     * 客户账号	是
     */
    private String AccountID;

    /**
     * 信息编号(同短信提交时产生的MsgID)	是
     */
    private String MsgID;

    /**
     * 客户提交手机号码	是
     */
    private String MobilePhone;

    /**
     * 状态报告说明(运营商送达手机终端的回执)，针对ReportState，建议客户端存储	是
     */
    private String ReportResultInfo;

    /**
     * 状态报告结果，True是成功，False是失败	是
     */
    private String ReportState;

    /**
     * 状态报告时间	是
     */
    private String ReportTime;

    /**
     * 发送结果，针对SendState	是
     */
    private String SendResultInfo;

    /**
     * 发送状态,供应商送达运营商网关的状态，True是成功，False是失败	是
     */
    private String SendState;

    /**
     * 短信发送时间	是
     */
    private String SendedTime;

    /**
     * 长号码（下发端口号）	是
     */
    private String SPNumber;

    /**
     * 客户端传入的自定义参数Key	否
     */
    private String ClientMsgId;

    /**
     * 客户端自定义扩展码	否
     */
    private String ExtendNum;

    /**
     * 长短信序号	否
     */
    private String LongMsgNum;

    /**
     * 长短信总条数	否
     */
    private String LongMsgTotal;

    /**
     * 供应商分类错误码	否
     */
    private String ReportCode;

    /**
     * 供应商关于回执错误码的中文说明	否
     */
    private String ReportDesc;

    @Override
    public String toString() {
        return "SmsUmcParam{" + "AccountID='" + AccountID + '\'' + ", MsgID='" + MsgID + '\'' + ", MobilePhone='" + MobilePhone + '\'' + ", ReportResultInfo='" + ReportResultInfo + '\'' + ", ReportState='" + ReportState + '\'' + ", ReportTime='" + ReportTime + '\'' + ", SendResultInfo='" + SendResultInfo + '\'' + ", SendState='" + SendState + '\'' + ", SendedTime='" + SendedTime + '\'' + ", SPNumber='" + SPNumber + '\'' + ", ClientMsgId='" + ClientMsgId + '\'' + ", ExtendNum='" + ExtendNum + '\'' + ", LongMsgNum='" + LongMsgNum + '\'' + ", LongMsgTotal='" + LongMsgTotal + '\'' + ", ReportCode='" + ReportCode + '\'' + ", ReportDesc='" + ReportDesc + '\'' + '}';
    }
}
