package cn.com.duiba.message.service.rest.controller;

import cn.com.duiba.message.service.api.dto.LetterDto;
import cn.com.duiba.message.service.api.dto.LetterRequestDto;
import cn.com.duiba.message.service.api.remoteservice.RemoteLetterService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.CsrfOff;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-10-16 16:03
 * @descript:
 * @version: 1.0
 */
@RestController()
@RequestMapping("/message/service/letter")
public class LetterController {

    @Resource
    private RemoteLetterService remoteLetterService;

    @Autowired
    private SsePushNotifySchedule ssePushNotifySchedule;

    @GetMapping("/my")
    public Result getMyLetters(LetterRequestDto requestDto) {

        Long adminId = RequestTool.getAdminId();
        requestDto.setReceiveId(String.valueOf(adminId));
        PageSerializable<LetterDto> letters = remoteLetterService.search(requestDto);
        return Result.setSucc(letters.getList(), (int) letters.getTotal());
    }

    @CsrfOff
    @GetMapping("/pushNew")
    public SseEmitter pushNewLetter() {

        SseEmitter emitter = new SseEmitter(86400000L);//1天后自动重连
        final Long adminId = RequestTool.getAdminId();
        if (adminId == null || ssePushNotifySchedule.isExist(String.valueOf(adminId))) {

            SseEmitter.SseEventBuilder builder = SseEmitter.event().data("rejected");
            try {
                emitter.send(builder);
                emitter.complete();
            } catch (IOException e) {
                emitter.completeWithError(e);
                //ignore
            }
            return emitter;
        }

        String adminIdStr = String.valueOf(adminId);
        ssePushNotifySchedule.registerEmitter(adminIdStr, emitter);
        return emitter;
    }

    @GetMapping("/hasNew")
    public Result hasNew() {

        final Long adminId = RequestTool.getAdminId();
        if (adminId == null) {
            return Result.setFail("未监测到登录信息");
        }

        String adminIdStr = String.valueOf(adminId);
        List<String> hasReceives = remoteLetterService.hasNewLetter(Sets.newHashSet(adminIdStr));
        return Result.setSucc(hasReceives.contains(adminIdStr));
    }

    @PostMapping("/read")
    public Result read(@RequestBody List<Long> letterIds) {

        final Long adminId = RequestTool.getAdminId();
        remoteLetterService.read(letterIds, String.valueOf(adminId));
        return Result.setSucc();
    }

    @PostMapping("/delete")
    public Result read(Long letterId) {

        final Long adminId = RequestTool.getAdminId();
        remoteLetterService.delete(letterId, String.valueOf(adminId));
        return Result.setSucc();
    }


}
