package cn.com.duiba.miria.common.api.entity;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

public class App implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private String name;

    @Column(name = "build_type")
    private String buildType;

    @Column(name = "git_url")
    private String gitUrl;

    /**
     * 服务端口
     */
    @Column(name = "service_port")
    private Integer servicePort;

    /**
     * 心跳检测地址
     */
    @Column(name = "heartbeat_path")
    private String heartbeatPath;

    private String description;

    @Column(name = "created_time")
    private Date createdTime;

    @Column(name = "modified_time")
    private Date modifiedTime;

    @Column(name = "group_id")
    private Long groupId;
    @Column(name ="check_time")
    private Integer checkTime;

    @Column(name = "publish_batch_size")
    private Integer publishBatchSize;

    private String lableKey;

    private String lableValue;

    private Integer delaySeconds;

    private Integer warmUpTime;

    private Integer switches; // 开关标志位

    private Boolean needAudit; // 发布是否需要审核

    private Boolean needScale; // 发布是否需要审核

    private Boolean acceleratePublish; // 是否加速发布

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * @return build_type
     */
    public String getBuildType() {
        return buildType;
    }

    /**
     * @param buildType
     */
    public void setBuildType(String buildType) {
        this.buildType = buildType == null ? null : buildType.trim();
    }

    /**
     * @return git_url
     */
    public String getGitUrl() {
        return gitUrl;
    }

    /**
     * @param gitUrl
     */
    public void setGitUrl(String gitUrl) {
        this.gitUrl = gitUrl == null ? null : gitUrl.trim();
    }

    /**
     * 获取服务端口
     *
     * @return service_port - 服务端口
     */
    public Integer getServicePort() {
        return servicePort;
    }

    /**
     * 设置服务端口
     *
     * @param servicePort 服务端口
     */
    public void setServicePort(Integer servicePort) {
        this.servicePort = servicePort;
    }

    /**
     * 获取心跳检测地址
     *
     * @return heartbeat_path - 心跳检测地址
     */
    public String getHeartbeatPath() {
        return heartbeatPath;
    }

    /**
     * 设置心跳检测地址
     *
     * @param heartbeatPath 心跳检测地址
     */
    public void setHeartbeatPath(String heartbeatPath) {
        this.heartbeatPath = heartbeatPath == null ? null : heartbeatPath.trim();
    }

    /**
     * @return description
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description
     */
    public void setDescription(String description) {
        this.description = description == null ? null : description.trim();
    }

    /**
     * @return created_time
     */
    public Date getCreatedTime() {
        return createdTime;
    }

    /**
     * @param createdTime
     */
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * @return modified_time
     */
    public Date getModifiedTime() {
        return modifiedTime;
    }

    /**
     * @param modifiedTime
     */
    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    /**
     * @return group_id
     */
    public Long getGroupId() {
        return groupId;
    }

    /**
     * @param groupId
     */
    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }


    public Integer getCheckTime() {
        return checkTime;
    }

    public void setCheckTime(Integer checkTime) {
        this.checkTime = checkTime;
    }

    public String getLableKey() {
        return lableKey;
    }

    public void setLableKey(String lableKey) {
        this.lableKey = lableKey;
    }

    public String getLableValue() {
        return lableValue;
    }

    public void setLableValue(String lableValue) {
        this.lableValue = lableValue;
    }

    public Integer getDelaySeconds() {
        return delaySeconds;
    }

    public void setDelaySeconds(Integer delaySeconds) {
        this.delaySeconds = delaySeconds;
    }

    public Integer getWarmUpTime() {
        return warmUpTime;
    }

    public void setWarmUpTime(Integer warmUpTime) {
        this.warmUpTime = warmUpTime;
    }

    public Integer getSwitches() {
        return switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    public Boolean getNeedAudit() {
        return needAudit;
    }

    public void setNeedAudit(Boolean needAudit) {
        this.needAudit = needAudit;
    }

    public Boolean getNeedScale() {
        return needScale;
    }

    public void setNeedScale(Boolean needScale) {
        this.needScale = needScale;
    }

    public Boolean getAcceleratePublish() {
        return acceleratePublish;
    }

    public void setAcceleratePublish(Boolean acceleratePublish) {
        this.acceleratePublish = acceleratePublish;
    }

    public Integer getPublishBatchSize() {
        return publishBatchSize;
    }

    public void setPublishBatchSize(Integer publishBatchSize) {
        this.publishBatchSize = publishBatchSize;
    }
}