package cn.com.duiba.miria.common.api.enums;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.util.Map;

@Getter
public enum PodStatusEnum {

    RUNNING("Running","服务中"),
    PENDING("Pending","调度中"),
    STARTING("Starting", "运行中"),
    SUCCESSED("Succeeded","正常退出"),
    FAILED("Failed","异常退出"),
    UNKNOWN("Unknown","未知");

    private static Map<String,PodStatusEnum> STATE_MAP = Maps.newHashMap();
    static {
        for(PodStatusEnum status:PodStatusEnum.values()){
            STATE_MAP.put(status.getCode(),status);
        }
    }


    PodStatusEnum(String code,String name){
        this.code = code;
        this.name = name;
    }

    private String code;
    private String name;


    public static PodStatusEnum findByCode(String code){
        return STATE_MAP.getOrDefault(code,UNKNOWN);
    }

}
