package cn.com.duiba.miria.common.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Map;

/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2019/3/27.
 **/

@AdvancedFeignClient
public interface PvcService {

    /**
     * 创建持久化存储
     * @param k8sProviderId
     * @param name
     * @param size
     * @param labels
     * @param path
     * @param server
     */
    void createNasPv(Long k8sProviderId, String name, String size, Map<String, String> labels, String path, String server) throws BizException;

    /**
     * 删除持久化存储
     * @param k8sProviderId
     * @param name
     * @throws BizException
     */
    void deleteNasPv(Long k8sProviderId, String name) throws BizException;

    /**
     * 创建存储类
     * @param k8sProviderId
     * @param name
     * @param size
     * @param labels
     */
    void createNasPvc(Long k8sProviderId, String name, String namespace, String size, Map<String, String> labels) throws BizException;

    /**
     * 删除存储类
     * @param k8sProviderId
     * @param name
     * @param namespace
     */
    void deletePvc(Long k8sProviderId, String name, String namespace) throws BizException;


}
