package cn.com.duiba.miria.common.api.util;

import cn.com.duiba.boot.exception.BizException;
import lombok.extern.slf4j.Slf4j;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Slf4j
public class ShellUtil {

    private ShellUtil() {

    }

    /**
     * 执行shell
     *
     * @param cmd 传入命令
     */
    public static String execShell(String cmd, Runtime runtime) throws BizException {

        String res = null;
        StringBuilder sb;
        log.info("execShell执行shell：{}", cmd);
        String[] cmdArr = new String[]{"/bin/sh", "-c", cmd};
        int status = 0;
        try {
            Process ps = runtime.exec(cmdArr);
            status = ps.waitFor();

            BufferedInputStream in = new BufferedInputStream(ps.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            sb = new StringBuilder();
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            res = sb.toString();
            br.close();
            in.close();
            ps.destroy();
            log.info("执行shell:{}返回{}", cmd, res);
        } catch (IOException e) {
            throw new BizException(e.getMessage());
        } catch (InterruptedException e) {
            log.error("Interrupted!", e);
            Thread.currentThread().interrupt();
        }

        if (status != 0) {
            throw new BizException("Failed to call shell's command:" + cmd + " and the return is" + res + ",and status's is: " + status);
        }
        return res;
    }

    public static void execVoidShell(String cmd, Runtime runtime) throws BizException {

        log.info("execVoidShell执行shell：{}", cmd);
        String[] cmdArr = new String[]{"/bin/sh", "-c", cmd};
        int status = 0;
        try {
            Process ps = runtime.exec(cmdArr);
            status = ps.waitFor();
            ps.destroy();
            log.info("执行shell:{}返回状态{}", cmd, status);
        } catch (IOException e) {
            throw new BizException(e.getMessage());
        } catch (InterruptedException e) {
            log.error("Interrupted!", e);
            Thread.currentThread().interrupt();
        }

        if (status != 0) {
            throw new BizException("Failed to call shell's command:" + cmd + ",and status's is: " + status);
        }

    }

    /**
     * 执行shell
     *
     * @param cmd  传入命令
     * @param path cd 到的path
     */
    public static String execShell(String cmd, String path, Runtime runtime) throws BizException {

        String res = null;
        StringBuilder sb;
        log.info("execShell执行shell：{}", cmd);
        String[] cmdArr = new String[]{"/bin/sh", "-c", "cd " + path + " && " + cmd};
        int status = 0;
        try {
            Process ps = runtime.exec(cmdArr);
            status = ps.waitFor();
            BufferedInputStream in = new BufferedInputStream(ps.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            sb = new StringBuilder();
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
            in.close();
            res = sb.toString();
            ps.destroy();
            log.info("执行shell:{}返回{}", cmd, res);
        } catch (IOException e) {
            throw new BizException(e.getMessage());
        } catch (InterruptedException e) {
            log.error("Interrupted!", e);
            Thread.currentThread().interrupt();
        }


        if (status != 0) {
            throw new BizException("Failed to call shell's command:cd " + path + " && " + cmd + " and the return is" + res + ",and status's is: " + status);
        }
        return res;

    }

    /**
     * 执行shell
     *
     * @param cmd 传入命令
     */
    public static String execShellByArr(String[] cmd) throws BizException {

        String res = null;
        StringBuilder sb;
        List<String> list = new ArrayList<>();
        list.add("/bin/sh");
        list.add("-c");
        StringBuilder stringBuffer = new StringBuilder();

        for (String command : cmd) {
            if (!Objects.equals(command, "")) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" && ").append(command);
                } else {
                    stringBuffer.append(command);
                }

            }
        }
        list.add(stringBuffer.toString());
        String[] cmdArr = list.toArray(new String[]{});
        int status = 0;
        try {
            Process ps = Runtime.getRuntime().exec(cmdArr);
            status = ps.waitFor();

            BufferedInputStream in = new BufferedInputStream(ps.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(in));

            sb = new StringBuilder();
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
            in.close();
            res = sb.toString();
            ps.destroy();
            log.info("执行shell返回{}", res);
        } catch (IOException e) {
            throw new BizException(e.getMessage());
        } catch (InterruptedException e) {
            log.error("Interrupted!", e);
            Thread.currentThread().interrupt();
        }

        if (status != 0) {
            throw new BizException("Failed to call shell's command:" + stringBuffer.toString() + " and the return is" + res + ",and status's is: " + status);
        }
        return res;

    }

    /**
     * 执行shell
     *
     * @param cmd  传入命令
     * @param path cd 到的path
     */
    public static void execShellByArr(String[] cmd, String path, Runtime runtime) throws BizException {

        List<String> list = new ArrayList<>();
        list.add("/bin/sh");
        list.add("-c");
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("cd ").append(path);

        for (String command : cmd) {
            if (!Objects.equals(command, "")) {
                stringBuffer.append(" && ").append(command);
            }
        }
        String command = stringBuffer.toString();
        list.add(command);
        String[] cmdArr = list.toArray(new String[]{});
        int status = 0;
        try {
            Process ps = runtime.exec(cmdArr);
            status = ps.waitFor();
            ps.destroy();
        } catch (IOException e) {
            throw new BizException(e.getMessage());
        } catch (InterruptedException e) {
            log.error("Interrupted!", e);
            Thread.currentThread().interrupt();
        }

        log.info("执行shell:{}返回status{}", command, status);
        if (status != 0) {
            throw new BizException("Failed to call shell's command:" + stringBuffer.toString() + ",and status's is: " + status);
        }

    }

}
