package cn.com.duiba.miria.common.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.entity.NodeBaseInfo;
import cn.com.duiba.miria.common.api.entity.NodeResource;

import java.util.List;

/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2018/9/12.
 **/
@AdvancedFeignClient
public interface NodeService {
    List<String> getClusterNodeIp() throws BizException;

    List<NodeResource> getNodeResource() throws BizException;

    String getNodeIpByPodName(String podName) throws BizException;

    String getNodeNameByPodName(String podName) throws BizException;

    List<NodeBaseInfo> getClusterNodeInfo() throws BizException;
}
