package cn.com.duiba.miria.common.api.remoteservice.bo;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.vo.AppPowerVO;


import java.util.List;


@AdvancedFeignClient
public interface AppPowerBo {


    /**
     * 用户组下，用户对App拥有权限的情况
     * @param groupId
     * @param adminId
     * @param envId
     * @return
     */
     List<AppPowerVO> getGroupAdminAppPower(Long groupId, Long adminId, Long envId);


    /**
     * 设置App权限
     * @param adminId
     * @param envId
     * @param appIds
     */
     void setAdminEnvPower(Long groupId, Long adminId, Long envId, List<Long> appIds) throws BizException;


}
