package cn.com.duiba.miria.common.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.entity.NodeBaseInfo;
import cn.com.duiba.miria.common.api.entity.NodeResource;
import cn.com.duiba.miria.common.api.entity.NodeResourceInfo;

import java.util.List;
import java.util.Map;

/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2018/9/12.
 **/
@AdvancedFeignClient
public interface NodeService {
    List<String> getClusterNodeIp() throws BizException;

    List<NodeResource> getNodeResource() throws BizException;

    String getNodeIpByPodName(String podName) throws BizException;

    String getNodeNameByPodName(String podName) throws BizException;

    List<NodeBaseInfo> getClusterNodeInfo() throws BizException;

    List<NodeResourceInfo> getIdleNodeResourceByLabel(Long k8sId, Map<String, String> labels) throws BizException;
}
