package cn.com.duiba.miria.common.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.entity.NodeBaseInfo;
import cn.com.duiba.miria.common.api.entity.NodeResource;
import cn.com.duiba.miria.common.api.entity.NodeResourceInfo;

import java.util.List;
import java.util.Map;

/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2018/9/12.
 **/
@AdvancedFeignClient
public interface NodeService {
    List<String> getClusterNodeIp() throws BizException;

    List<NodeResource> getNodeResource() throws BizException;

    String getNodeIpByPodName(String podName) throws BizException;

    String getNodeNameByPodName(String podName) throws BizException;

    List<NodeBaseInfo> getClusterNodeInfo() throws BizException;

    List<NodeResourceInfo> getIdleNodeResourceByLabel(Long k8sId, Map<String, String> labels) throws BizException;

    Map<String, Integer> getNodeCpuByLabels() throws BizException;

    /**
     * 判断指定集群里指定节点是否存在
     *
     * @param k8sId    集群id
     * @param nodeName 节点名
     * @return 判断结果
     */
    Boolean nodeExist(Long k8sId, String nodeName) throws BizException;

    /**
     * 判断指定集群里指定节点是否已经ready
     *
     * @param k8sId    集群id
     * @param nodeName 节点名
     * @return 判断结果
     */
    Boolean nodeIsReady(Long k8sId, String nodeName) throws BizException;

    /**
     * 给指定集群的指定节点添加标签
     *
     * @param k8sId    集群id
     * @param nodeName 节点名
     * @param labels   标签
     */
    void putLabelsToNode(Long k8sId, String nodeName, Map<String, String> labels) throws BizException;

    /**
     * 判断指定集群的指定节点是否有指定标签
     *
     * @param k8sId    集群id
     * @param nodeName 节点名
     * @param labels   标签
     * @return 判断结果
     */
    Boolean labelsExist(Long k8sId, String nodeName, Map<String, String> labels) throws BizException;

    /**
     * 根据节点名删除指定集群里的节点
     *
     * @param k8sId    集群id
     * @param nodeName 节点名
     * @throws BizException
     */
    void deleteNode(Long k8sId, String nodeName) throws BizException;

    /**
     * 查询指定集群里没有pod在上面部署的节点
     *
     * @param k8sId 集群id
     * @return 没有pod在上面部署的节点
     */
    List<NodeBaseInfo> getNodesWithNoPods(Long k8sId);

}
