package cn.com.duiba.miria.common.api.entity;

import javax.persistence.*;
import java.util.Date;

@Table(name = "tb_k8s_event")
public class K8sEvent {
    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 应用名称
     */
    @Column(name = "app_name")
    private String appName;

    /**
     * pod名称
     */
    @Column(name = "pod_name")
    private String podName;

    /**
     * 宿主机名
     */
    @Column(name = "host_name")
    private String hostName;

    /**
     * 事件类型
     */
    @Column(name = "event_type")
    private String eventType;

    /**
     * 事件详情
     */
    @Column(name = "event_message")
    private String eventMessage;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 获取主键id
     *
     * @return id - 主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置主键id
     *
     * @param id 主键id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取应用名称
     *
     * @return app_name - 应用名称
     */
    public String getAppName() {
        return appName;
    }

    /**
     * 设置应用名称
     *
     * @param appName 应用名称
     */
    public void setAppName(String appName) {
        this.appName = appName == null ? null : appName.trim();
    }

    /**
     * 获取pod名称
     *
     * @return pod_name - pod名称
     */
    public String getPodName() {
        return podName;
    }

    /**
     * 设置pod名称
     *
     * @param podName pod名称
     */
    public void setPodName(String podName) {
        this.podName = podName == null ? null : podName.trim();
    }

    /**
     * 获取宿主机名
     *
     * @return host_name - 宿主机名
     */
    public String getHostName() {
        return hostName;
    }

    /**
     * 设置宿主机名
     *
     * @param hostName 宿主机名
     */
    public void setHostName(String hostName) {
        this.hostName = hostName == null ? null : hostName.trim();
    }

    /**
     * 获取事件类型
     *
     * @return event_type - 事件类型
     */
    public String getEventType() {
        return eventType;
    }

    /**
     * 设置事件类型
     *
     * @param eventType 事件类型
     */
    public void setEventType(String eventType) {
        this.eventType = eventType == null ? null : eventType.trim();
    }

    /**
     * 获取事件详情
     *
     * @return event_message - 事件详情
     */
    public String getEventMessage() {
        return eventMessage;
    }

    /**
     * 设置事件详情
     *
     * @param eventMessage 事件详情
     */
    public void setEventMessage(String eventMessage) {
        this.eventMessage = eventMessage == null ? null : eventMessage.trim();
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}