/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2018/6/27.
 **/
package cn.com.duiba.miria.common.api.enums;
import lombok.Getter;

@Getter
public enum DeployTypeEnum {

    NORMAL(0,"正式","normal"),
    FORTRESS(1,"灰度","fortress");

    private Integer code;
    private String typeName;
    private String alias;

    DeployTypeEnum(Integer code,String typeName,String alias){
        this.code = code;
        this.typeName = typeName;
        this.alias = alias;
    }

    public static DeployTypeEnum findByCode(Integer code){
        switch(code){
            case 0:return NORMAL;
            case 1:return FORTRESS;
            default:return NORMAL;
        }
    }

}
