package cn.com.duiba.miria.common.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wrj
 */

@AllArgsConstructor
@Getter
public enum K8sEventTypeEnum {

    Pulled("Pulled", "镜像拉取成功"),
    Started("Started", "启动完成，开始检测"),
    Unhealthy("Unhealthy", "健康检查失败"),
    Killing("Killing", "正在销毁"),
    Failed("Failed", "任务失败"),
    BackOff("BackOff", "失败重试");

    private String key;
    private String expr;

    public static List<String> getKeyList() {
        List<String> list = new ArrayList<>();
        for (K8sEventTypeEnum anEnum : K8sEventTypeEnum.values()) {
            list.add(anEnum.getKey());
        }

        return list;
    }

}
