package cn.com.duiba.miria.common.api.remoteservice.bo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.entity.App;
import cn.com.duiba.miria.common.api.entity.Group;

import java.util.List;
import java.util.Set;

@AdvancedFeignClient
public interface SSOPowerBo {
    /**
     * 从sso查询所有的业务线
     * */
    List<Group> getAllGroup();
    /**
     * 根据sso的关注功能结合当前用户的权限  miria-publish的管理员（看全部）/业务线负责人、应用owner、应用成员 （查看关注应用）
     * 查询当前用户可以看见的部署
     * */
    List<App> getVisibleApp(Long adminId);
    /**
     * 查询当前用户是否对当前应用有发布权限
     * 测试环境 应用成员有发布权限 应用owner没有发布权限
     * 其他环境 应用成员有没有发布权限 应用owner有发布权限
     * @param adminId
     * @param appName
     * @return
     * */
    Boolean hasPublishPower(Long adminId,String appName);
    /**
     * 是否是管理员
     * */
    Boolean isMaster(Long adminId);
    /**
     * 查询当前用户是对应应用的什么权限
     * 管理员、业务线负责人、owner、成员 关联 SSOPowerTypeEnum
     * */
    Integer getAppPowerLvByAdminId(Long adminId, String appName);
    /**
     * 获取当前应用的业务线负责人
     * @param appName
     * @return adminId
     * */
    List<Long> getLeaderAdminId(String appName);
    /**
     * 获取应用所在业务线
     * */
    Long getGroupIdByAppName(String appName);

    /**
     * 判断当前用户是不是业务线负责人
     * 是返回业务线Id list
     * 不是返回空结合
     * */
    List<Long> getLeaderGroupIds(Long adminId);

    /**
     *查询用户有权限的app
     * */
    List<App>  getPowerApps(Long adminId);
    /**
     * 获取一个admin担任成员的所有app
     * */
    Set<String> getOwnerAppNames(Long adminId);

    /**
     * 根据应用名称获取业务线
     * */
    Group getAppGroupInfo(String appName);

}
