/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.miria.common.api.util;

import cn.com.duiba.boot.exception.BizException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellUtil {
    private static final Logger log = LoggerFactory.getLogger(ShellUtil.class);

    private ShellUtil() {
    }

    public static String execShell(String cmd, Runtime runtime) throws BizException {
        String res = null;
        log.info("execShell\u6267\u884cshell\uff1a{}", (Object)cmd);
        String[] cmdArr = new String[]{"/bin/sh", "-c", cmd};
        int status = 0;
        try {
            String line;
            Process ps = runtime.exec(cmdArr);
            status = ps.waitFor();
            BufferedInputStream in = new BufferedInputStream(ps.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            res = sb.toString();
            br.close();
            in.close();
            ps.destroy();
            log.info("\u6267\u884cshell:{}\u8fd4\u56de{}", (Object)cmd, (Object)res);
        }
        catch (IOException e) {
            throw new BizException(e.getMessage());
        }
        catch (InterruptedException e) {
            log.error("Interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (status != 0) {
            throw new BizException("Failed to call shell's command:" + cmd + " and the return is" + res + ",and status's is: " + status);
        }
        return res;
    }

    public static void execVoidShell(String cmd, Runtime runtime) throws BizException {
        log.info("execVoidShell\u6267\u884cshell\uff1a{}", (Object)cmd);
        String[] cmdArr = new String[]{"/bin/sh", "-c", cmd};
        int status = 0;
        try {
            Process ps = runtime.exec(cmdArr);
            status = ps.waitFor();
            ps.destroy();
            log.info("\u6267\u884cshell:{}\u8fd4\u56de\u72b6\u6001{}", (Object)cmd, (Object)status);
        }
        catch (IOException e) {
            throw new BizException(e.getMessage());
        }
        catch (InterruptedException e) {
            log.error("Interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (status != 0) {
            throw new BizException("Failed to call shell's command:" + cmd + ",and status's is: " + status);
        }
    }

    public static String execShell(String cmd, String path, Runtime runtime) throws BizException {
        String res = null;
        log.info("execShell\u6267\u884cshell\uff1a{}", (Object)cmd);
        String[] cmdArr = new String[]{"/bin/sh", "-c", "cd " + path + " && " + cmd};
        int status = 0;
        try {
            String line;
            Process ps = runtime.exec(cmdArr);
            status = ps.waitFor();
            BufferedInputStream in = new BufferedInputStream(ps.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
            in.close();
            res = sb.toString();
            ps.destroy();
            log.info("\u6267\u884cshell:{}\u8fd4\u56de{}", (Object)cmd, (Object)res);
        }
        catch (IOException e) {
            throw new BizException(e.getMessage());
        }
        catch (InterruptedException e) {
            log.error("Interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (status != 0) {
            throw new BizException("Failed to call shell's command:cd " + path + " && " + cmd + " and the return is" + res + ",and status's is: " + status);
        }
        return res;
    }

    public static String execShellByArr(String[] cmd) throws BizException {
        String res = null;
        ArrayList<String> list = new ArrayList<String>();
        list.add("/bin/sh");
        list.add("-c");
        StringBuilder stringBuffer = new StringBuilder();
        for (String command : cmd) {
            if (Objects.equals(command, "")) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" && ").append(command);
                continue;
            }
            stringBuffer.append(command);
        }
        list.add(stringBuffer.toString());
        String[] cmdArr = list.toArray(new String[0]);
        int status = 0;
        try {
            String line;
            Process ps = Runtime.getRuntime().exec(cmdArr);
            status = ps.waitFor();
            BufferedInputStream in = new BufferedInputStream(ps.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
            in.close();
            res = sb.toString();
            ps.destroy();
            log.info("\u6267\u884cshell\u8fd4\u56de{}", (Object)res);
        }
        catch (IOException e) {
            throw new BizException(e.getMessage());
        }
        catch (InterruptedException e) {
            log.error("Interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (status != 0) {
            throw new BizException("Failed to call shell's command:" + stringBuffer.toString() + " and the return is" + res + ",and status's is: " + status);
        }
        return res;
    }

    public static void execShellByArr(String[] cmd, String path, Runtime runtime) throws BizException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("/bin/sh");
        list.add("-c");
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("cd ").append(path);
        for (String command : cmd) {
            if (Objects.equals(command, "")) continue;
            stringBuffer.append(" && ").append(command);
        }
        String command = stringBuffer.toString();
        list.add(command);
        String[] cmdArr = list.toArray(new String[0]);
        int status = 0;
        try {
            Process ps = runtime.exec(cmdArr);
            status = ps.waitFor();
            ps.destroy();
        }
        catch (IOException e) {
            throw new BizException(e.getMessage());
        }
        catch (InterruptedException e) {
            log.error("Interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        log.info("\u6267\u884cshell:{}\u8fd4\u56destatus{}", (Object)command, (Object)status);
        if (status != 0) {
            throw new BizException("Failed to call shell's command:" + stringBuffer.toString() + ",and status's is: " + status);
        }
    }
}

