package cn.com.duiba.miria.common.api.entity;

import javax.persistence.*;
import java.util.Date;

@Table(name = "k8s_provider")
public class K8sProvider {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private String name;

    @Column(name = "credentials_id")
    private Long credentialsId;

    @Column(name = "zone_id")
    private Long zoneId;

    /**
     * 是否用于容器伸缩
     */
    private Boolean scalable;

    /**
     * 对应的阿里云k8s集群id
     */
    @Column(name = "kubernetes_id")
    private String kubernetesId;

    @Column(name = "created_time")
    private Date createdTime;

    @Column(name = "modified_time")
    private Date modifiedTime;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * @return credentials_id
     */
    public Long getCredentialsId() {
        return credentialsId;
    }

    /**
     * @param credentialsId
     */
    public void setCredentialsId(Long credentialsId) {
        this.credentialsId = credentialsId;
    }

    /**
     * @return zone_id
     */
    public Long getZoneId() {
        return zoneId;
    }

    /**
     * @param zoneId
     */
    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    /**
     * 获取是否用于容器伸缩
     *
     * @return scalable - 是否用于容器伸缩
     */
    public Boolean getScalable() {
        return scalable;
    }

    /**
     * 设置是否用于容器伸缩
     *
     * @param scalable 是否用于容器伸缩
     */
    public void setScalable(Boolean scalable) {
        this.scalable = scalable;
    }

    /**
     * 获取对应的阿里云k8s集群id
     *
     * @return kubernetes_id - 对应的阿里云k8s集群id
     */
    public String getKubernetesId() {
        return kubernetesId;
    }

    /**
     * 设置对应的阿里云k8s集群id
     *
     * @param kubernetesId 对应的阿里云k8s集群id
     */
    public void setKubernetesId(String kubernetesId) {
        this.kubernetesId = kubernetesId == null ? null : kubernetesId.trim();
    }

    /**
     * @return created_time
     */
    public Date getCreatedTime() {
        return createdTime;
    }

    /**
     * @param createdTime
     */
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * @return modified_time
     */
    public Date getModifiedTime() {
        return modifiedTime;
    }

    /**
     * @param modifiedTime
     */
    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }
}