package cn.com.duiba.miria.common.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.data.DeployInfo;
import cn.com.duiba.miria.common.api.entity.NewDeploymentInfo;
import io.fabric8.kubernetes.api.model.extensions.Deployment;

import java.util.List;
import java.util.Map;

/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2018/6/27.
 **/
@AdvancedFeignClient
public interface DeployK8sService {

    DeployInfo checkFromK8s(Long clusterId, Long deployId, String deploymentName) throws BizException;

    DeployInfo checkSceneTestDeployFromK8s(Long clusterId, String deploymentName) throws BizException;


    void publishToK8s(Long k8sId, Deployment deployment) throws BizException;

    void destroyFromK8s(Long deployId, String deploymentName) throws BizException;

    void deleteDeployment(Long deployId, String deploymentName) throws BizException;

    void destroyScaleFromK8s(Long k8sId, String deploymentName) throws BizException;

    /**
     * 删除指定集群deployment
     *
     * @param k8sId
     * @param deploymentName
     * @throws BizException
     */
    void deleteScaleDeployment(Long k8sId, String deploymentName) throws BizException;

    void publishNewDeploymentFromOldDeployment(Long k8sId, String oldDeploymentName, String newDeploymentName, Integer newReplicaNum) throws BizException;

    /**
     * 通过旧的deployment构造新的deployment，并发到指定集群
     *
     * @param k8sId             集群id
     * @param oldDeploymentName 旧deployment名
     * @param newDeploymentInfo 新deployment信息
     */
    void publishNewDeployment(Long k8sId, String oldDeploymentName, NewDeploymentInfo newDeploymentInfo) throws BizException;

    /**
     * 查询指定标签一组deployment的名字集合
     *
     * @param k8sId  集群id
     * @param labels 标签
     * @return
     */
    List<String> getDeploymentNamesByLabel(Long k8sId, Map<String, String> labels) throws BizException;


    void destroySceneTestPodFromK8s(Long k8sId, String deploymentName) throws BizException;

    void pauseDeployment(Long k8sId, String deploymentName,Boolean paused);

    Boolean queryPausedStatus(Long k8sId, String deploymentName);
}
