package cn.com.duiba.miria.common.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.data.ContainerInfo;
import cn.com.duiba.miria.common.api.data.PodInfo;
import cn.com.duiba.miria.common.api.entity.App;

import java.util.List;
import java.util.Map;

/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2018/6/27.
 **/
@AdvancedFeignClient
public interface PodService {
    List<PodInfo> getDeployPodsInfo(Long clusterId, String deploymentName) throws BizException;

    List<PodInfo> getPodsByNamespaceAndDeployment(Long k8sId,String namespace, String deploymentName) throws BizException;


    String getPodLog(Long clusterId, String podName, String containerId);

    void resizeFortressDeployment(Long k8sId, String nameSpace, String deploymentName, int size) throws BizException;

    List<ContainerInfo> ListContainerInfo(List<App> appList) throws BizException;

    Integer getAppPodsNum(String appName) throws BizException;

    List<PodInfo> getDeployPodsInfoByAppName(Long clusterId, String appName) throws BizException;

    List<String> getNodeNamesByDeploymentName(Long k8sId, String deploymentName) throws BizException;

    List<PodInfo> getPodsInfoByLabels(Map<String, String> labels);

    /**
     * 通过pod名称查询ip
     *
     * @param podName pod名
     * @return ip
     */
    String getIpByPodName(String podName) throws BizException;

    String getPodLogNewWay(Long k8sId, String podName, String containerId) throws BizException;

    void deletePod(Long k8sId,String nameSpace,String podName)throws BizException;


}
