package cn.com.duiba.miria.publish.api.entity;


import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;
@ToString
public  class Publish implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "deploy_id")
    private Long deployId;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "image_id")
    private Long imageId;

    @Column(name = "jenkins_job_id")
    private Integer jenkinsJobId;

    @Column(name = "env_vars")
    private String envVars;

    private String command;

    private String args;

    @Column(name = "git_branch")
    private String gitBranch;

    private String tag;

    @Column(name = "state_index")
    private String stateIndex;

    @Column(name = "state_result")
    private Integer stateResult;

    /**
     * 错误日志
     */
    @Column(name = "error_message")
    private String errorMessage;

    @Column(name = "created_time")
    private Date createdTime;

    @Column(name = "modified_time")
    private Date modifiedTime;

    /**
     * 发布机器名称
     */
    @Column(name = "pod_name")
    private String podName;

    @Column(name = "publish_type")
    private Integer publishType;

    @Column(name = "target_ip_id")
    private Long targetIpId;

    @Column(name = "release_path")
    private String releasePath;

    /**
     * 最后一次发布日志
     */
    @Column(name = "publish_log")
    private String publishLog;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return deploy_id
     */
    public Long getDeployId() {
        return deployId;
    }

    /**
     * @param deployId
     */
    public void setDeployId(Long deployId) {
        this.deployId = deployId;
    }

    /**
     * @return user_id
     */
    public Long getUserId() {
        return userId;
    }

    /**
     * @param userId
     */
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    /**
     * @return image_id
     */
    public Long getImageId() {
        return imageId;
    }

    /**
     * @param imageId
     */
    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    /**
     * @return jenkins_job_id
     */
    public Integer getJenkinsJobId() {
        return jenkinsJobId;
    }

    /**
     * @param jenkinsJobId
     */
    public void setJenkinsJobId(Integer jenkinsJobId) {
        this.jenkinsJobId = jenkinsJobId;
    }

    /**
     * @return env_vars
     */
    public String getEnvVars() {
        return envVars;
    }

    /**
     * @param envVars
     */
    public void setEnvVars(String envVars) {
        this.envVars = envVars == null ? null : envVars.trim();
    }

    /**
     * @return command
     */
    public String getCommand() {
        return command;
    }

    /**
     * @param command
     */
    public void setCommand(String command) {
        this.command = command == null ? null : command.trim();
    }

    /**
     * @return args
     */
    public String getArgs() {
        return args;
    }

    /**
     * @param args
     */
    public void setArgs(String args) {
        this.args = args == null ? null : args.trim();
    }

    /**
     * @return git_branch
     */
    public String getGitBranch() {
        return gitBranch;
    }

    /**
     * @param gitBranch
     */
    public void setGitBranch(String gitBranch) {
        this.gitBranch = gitBranch == null ? null : gitBranch.trim();
    }

    /**
     * @return tag
     */
    public String getTag() {
        return tag;
    }

    /**
     * @param tag
     */
    public void setTag(String tag) {
        this.tag = tag == null ? null : tag.trim();
    }

    /**
     * @return state_index
     */
    public String getStateIndex() {
        return stateIndex;
    }

    /**
     * @param stateIndex
     */
    public void setStateIndex(String stateIndex) {
        this.stateIndex = stateIndex == null ? null : stateIndex.trim();
    }

    /**
     * @return state_result
     */
    public Integer getStateResult() {
        return stateResult;
    }

    /**
     * @param stateResult
     */
    public void setStateResult(Integer stateResult) {
        this.stateResult = stateResult;
    }

    /**
     * 获取错误日志
     *
     * @return error_message - 错误日志
     */
    public String getErrorMessage() {
        return errorMessage;
    }

    /**
     * 设置错误日志
     *
     * @param errorMessage 错误日志
     */
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage == null ? null : errorMessage.trim();
    }

    /**
     * @return created_time
     */
    public Date getCreatedTime() {
        return createdTime;
    }

    /**
     * @param createdTime
     */
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * @return modified_time
     */
    public Date getModifiedTime() {
        return modifiedTime;
    }

    /**
     * @param modifiedTime
     */
    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    /**
     * 获取发布机器名称
     *
     * @return pod_name - 发布机器名称
     */
    public String getPodName() {
        return podName;
    }

    /**
     * 设置发布机器名称
     *
     * @param podName 发布机器名称
     */
    public void setPodName(String podName) {
        this.podName = podName == null ? null : podName.trim();
    }

    /**
     * @return publish_type
     */
    public Integer getPublishType() {
        return publishType;
    }

    /**
     * @param publishType
     */
    public void setPublishType(Integer publishType) {
        this.publishType = publishType;
    }

    /**
     * @return target_ip_id
     */
    public Long getTargetIpId() {
        return targetIpId;
    }

    /**
     * @param targetIpId
     */
    public void setTargetIpId(Long targetIpId) {
        this.targetIpId = targetIpId;
    }

    /**
     * @return release_path
     */
    public String getReleasePath() {
        return releasePath;
    }

    /**
     * @param releasePath
     */
    public void setReleasePath(String releasePath) {
        this.releasePath = releasePath == null ? null : releasePath.trim();
    }

    /**
     * 获取最后一次发布日志
     *
     * @return publish_log - 最后一次发布日志
     */
    public String getPublishLog() {
        return publishLog;
    }

    /**
     * 设置最后一次发布日志
     *
     * @param publishLog 最后一次发布日志
     */
    public void setPublishLog(String publishLog) {
        this.publishLog = publishLog == null ? null : publishLog.trim();
    }
}