package cn.com.duiba.miria.publish.api.entity;

import java.util.Date;
import javax.persistence.*;

@Table(name = "tb_daily_average_publish_time_cost")
public class DailyAveragePublishTimeCost {
    /**
     * 物理主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 发布平均耗时，单位秒
     */
    @Column(name = "time_cost")
    private Integer timeCost;

    /**
     * 创建时间
     */
    @Column(name = "gmt_creat")
    private Date gmtCreat;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 获取物理主键
     *
     * @return id - 物理主键
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置物理主键
     *
     * @param id 物理主键
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取发布平均耗时，单位秒
     *
     * @return time_cost - 发布平均耗时，单位秒
     */
    public Integer getTimeCost() {
        return timeCost;
    }

    /**
     * 设置发布平均耗时，单位秒
     *
     * @param timeCost 发布平均耗时，单位秒
     */
    public void setTimeCost(Integer timeCost) {
        this.timeCost = timeCost;
    }

    /**
     * 获取创建时间
     *
     * @return gmt_creat - 创建时间
     */
    public Date getGmtCreat() {
        return gmtCreat;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreat 创建时间
     */
    public void setGmtCreat(Date gmtCreat) {
        this.gmtCreat = gmtCreat;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}