package cn.com.duiba.miria.publish.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.entity.AliyunLogEntity;

import java.util.List;


@AdvancedFeignClient
public interface AliyunLogService {

    /**
     * 查询日志
     *
     * @param logStore  日志库
     * @param from      查询开始时间点精度为秒 例：1409529600
     * @param to        查询结束时间点精度为秒
     * @param topic     查询日志主题
     * @param query     查询表达式
     * @param pageIndex 页数
     * @param pageSize  每页日志数量
     * @return List<AliyunLogEntity>
     */
    List<AliyunLogEntity> getLogs(String logStore, int from, int to, String topic, String query, int pageIndex, int pageSize);

    /**
     * 查询总日志条数
     *
     * @param logStore 日志库
     * @param from     查询开始时间点精度为秒 例：1409529600
     * @param to       查询结束时间点精度为秒
     * @param topic    查询日志主题
     * @param query    查询表达式
     * @return int 日志总量
     */
    Long getLogsCount(String logStore, int from, int to, String topic, String query);


}
