/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2017/12/28.
 **/
package cn.com.duiba.miria.publish.api.constant;


import cn.com.duiba.miria.publish.api.entity.PasswordEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.AesCipherService;

import java.util.List;

@Slf4j
public class EncryptionUtil {

    private static final String APP_KEY = "sA1FGmFsXUHwPXrJOyWYfA==";
    //用于回写页面的虚假密码
    public static final String RETURN_PAGE_KEY = "sA1FGmFsXUHwPX";

    private static AesCipherService aesCipherService = new AesCipherService();
    static{
        aesCipherService.setKeySize(Const.KEY_LEN);
    }


    public static String encrypt(String text) {

        if(StringUtils.isBlank(text)){
            return "";
        }
        if(StringUtils.equals(RETURN_PAGE_KEY,text)){
            return null;
        }

        byte[] bytes = Base64.decode(APP_KEY.getBytes());
        return aesCipherService.encrypt(text.getBytes(), bytes).toBase64();
    }

    public static String decrypt(String encrptText) {
        if(StringUtils.isBlank(encrptText)){
            return "";
        }
        byte[] bytes = Base64.decode(APP_KEY.getBytes());
        return new String(aesCipherService.decrypt(Base64.decode(encrptText.getBytes()), bytes).getBytes());
    }


    public static void batchDecrypt(List<? extends PasswordEntity> list){
        for(PasswordEntity passwordEntity:list){
            decrypt(passwordEntity);
        }
    }

    public static <T extends PasswordEntity> void decrypt(T passwordEntity){
        if(passwordEntity==null){
            return;
        }
        String password = passwordEntity.getPassword();
        passwordEntity.setPassword(decrypt(password));

    }

    public static void main(String[] args) {

        System.out.println(decrypt("TOmEE3s42uQvcCd5H5Bu5Mu69YawxRoniD+lTDHC7Js="));

    }
}

