package cn.com.duiba.miria.publish.api.constant;

import cn.com.duiba.boot.exception.BizException;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TolerationBuilder;
import lombok.Data;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.*;

@RefreshScope
@ConfigurationProperties("k8s.system")
@Data
@Component
public class SystemProperties {

    private List<String> lableKey;

    private List<String> lableValue;

    private List<String> taintKey;

    private List<String> taintValue;

    private List<String> taintOperator;

    private List<String> taintEffect;

    public Map<String,String> getLableMaps() throws BizException{
        Map<String,String> map=new HashMap<>();
        if(!Objects.isNull(lableKey)&&!Objects.isNull(lableValue)){
           if(lableKey.size()!=lableValue.size()){
               throw new BizException("k8s.system.lable key value不匹配");
           }
           for(Integer i=0;i<lableKey.size();i++){
               map.put(lableKey.get(i),lableValue.get(i));
           }

        }
        return map;
    }

    public List<Toleration> getTolerationList(){
        List<Toleration> tolerationList=new ArrayList<>();
        if(!Objects.isNull(taintKey)&&!Objects.isNull(taintValue)&&!Objects.isNull(taintOperator)&&!Objects.isNull(taintEffect)){
            for(Integer i=0;i<taintKey.size();i++){
                Toleration toleration = new TolerationBuilder().withKey(taintKey.get(i))
                        .withEffect(taintEffect.get(i)).withOperator(taintOperator.get(i)).withValue(taintValue.get(i)).build();
                tolerationList.add(toleration);
            }
        }
        return tolerationList;
    }

}
