package cn.com.duiba.miria.publish.api.entity;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

public class Deploy implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "app_id")
    private Long appId;

    /**
     * 发布类型，默认 0:正式 1堡垒
     */
    @Column(name = "deploy_type")
    private Integer deployType;

    @Column(name = "cloud_id")
    private Long cloudId;

    @Column(name = "env_id")
    private Long envId;

    /**
     * 部署机器的台数
     */
    @Column(name = "instance_num")
    private Integer instanceNum;

    /**
     * 内存的大小（GB）
     */
    private Integer memory;

    @Column(name = "default_git_branch")
    private String defaultGitBranch;

    /**
     * 内核数
     */
    private Float cpu;

    /**
     * 与10相除，得到cpu实际分配占比
     */
    @Column(name = "cpu_request")
    private Integer cpuRequest;

    private Integer state;

    @Column(name = "created_time")
    private Date createdTime;

    @Column(name = "modified_time")
    private Date modifiedTime;

    /**
     * 是否自动部署，0表示否，1表示是
     */
    @Column(name = "auto_deploy")
    private Integer autoDeploy;

    /**
     * 最后一次发布日志
     */
    @Column(name = "publish_log")
    private String publishLog;

    /**
     * 最后一次发布日志
     */
    @Column(name = "deployment_type")
    private Integer deploymentType;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return app_id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * @param appId
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * 获取发布类型，默认 0:正式 1堡垒
     *
     * @return deploy_type - 发布类型，默认 0:正式 1堡垒
     */
    public Integer getDeployType() {
        return deployType;
    }

    /**
     * 设置发布类型，默认 0:正式 1堡垒
     *
     * @param deployType 发布类型，默认 0:正式 1堡垒
     */
    public void setDeployType(Integer deployType) {
        this.deployType = deployType;
    }

    /**
     * @return cloud_id
     */
    public Long getCloudId() {
        return cloudId;
    }

    /**
     * @param cloudId
     */
    public void setCloudId(Long cloudId) {
        this.cloudId = cloudId;
    }

    /**
     * @return env_id
     */
    public Long getEnvId() {
        return envId;
    }

    /**
     * @param envId
     */
    public void setEnvId(Long envId) {
        this.envId = envId;
    }

    /**
     * 获取部署机器的台数
     *
     * @return instance_num - 部署机器的台数
     */
    public Integer getInstanceNum() {
        return instanceNum;
    }

    /**
     * 设置部署机器的台数
     *
     * @param instanceNum 部署机器的台数
     */
    public void setInstanceNum(Integer instanceNum) {
        this.instanceNum = instanceNum;
    }

    /**
     * 获取内存的大小（GB）
     *
     * @return memory - 内存的大小（GB）
     */
    public Integer getMemory() {
        return memory;
    }

    /**
     * 设置内存的大小（GB）
     *
     * @param memory 内存的大小（GB）
     */
    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    /**
     * @return default_git_branch
     */
    public String getDefaultGitBranch() {
        return defaultGitBranch;
    }

    /**
     * @param defaultGitBranch
     */
    public void setDefaultGitBranch(String defaultGitBranch) {
        this.defaultGitBranch = defaultGitBranch == null ? null : defaultGitBranch.trim();
    }

    /**
     * 获取内核数
     *
     * @return cpu - 内核数
     */
    public Float getCpu() {
        return cpu;
    }

    /**
     * 设置内核数
     *
     * @param cpu 内核数
     */
    public void setCpu(Float cpu) {
        this.cpu = cpu;
    }

    /**
     * 获取与10相除，得到cpu实际分配占比
     *
     * @return cpu_request - 与10相除，得到cpu实际分配占比
     */
    public Integer getCpuRequest() {
        return cpuRequest;
    }

    /**
     * 设置与10相除，得到cpu实际分配占比
     * @param cpuRequest 与10相除，得到cpu实际分配占比
     */
    public void setCpuRequest(Integer cpuRequest) {
        this.cpuRequest = cpuRequest;
    }

    /**
     * @return state
     */
    public Integer getState() {
        return state;
    }

    /**
     * @param state
     */
    public void setState(Integer state) {
        this.state = state;
    }

    /**
     * @return created_time
     */
    public Date getCreatedTime() {
        return createdTime;
    }

    /**
     * @param createdTime
     */
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * @return modified_time
     */
    public Date getModifiedTime() {
        return modifiedTime;
    }

    /**
     * @param modifiedTime
     */
    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    /**
     * 获取是否自动部署，0表示否，1表示是
     *
     * @return auto_deploy - 是否自动部署，0表示否，1表示是
     */
    public Integer getAutoDeploy() {
        return autoDeploy;
    }

    /**
     * 设置是否自动部署，0表示否，1表示是
     *
     * @param autoDeploy 是否自动部署，0表示否，1表示是
     */
    public void setAutoDeploy(Integer autoDeploy) {
        this.autoDeploy = autoDeploy;
    }

    /**
     * 获取最后一次发布日志
     *
     * @return publish_log - 最后一次发布日志
     */
    public String getPublishLog() {
        return publishLog;
    }

    /**
     * 设置最后一次发布日志
     *
     * @param publishLog 最后一次发布日志
     */
    public void setPublishLog(String publishLog) {
        this.publishLog = publishLog == null ? null : publishLog.trim();
    }


    public Integer getDeploymentType() {
        return deploymentType;
    }

    public void setDeploymentType(Integer deploymentType) {
        this.deploymentType = deploymentType;
    }
}