package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.entity.Deploy;
import cn.com.duiba.miria.publish.api.entity.TbClusterPublishStrategy;
import cn.com.duiba.miria.publish.api.vo.PublishStrategyAppsVO;
import cn.com.duiba.miria.publish.api.vo.PublishStrategyResultVO;
import cn.com.duiba.miria.publish.api.vo.PublishStrategyVO;

import java.util.List;

@AdvancedFeignClient
public interface PublishStrategyService {

    List<PublishStrategyVO> getAllStrategy();

    void saveStrategy(PublishStrategyVO publishStrategyVO) throws BizException;

    void updateStrategy(PublishStrategyVO publishStrategyVO)throws BizException;

    void deleteStrategy(Long id) throws BizException;

    PublishStrategyVO getDetailById(Long strategyId);


    PublishStrategyAppsVO queryAppsByStrategyId(Long strategyId);

    void addRelationApps(Long strategyId, List<Long> appIds)throws BizException;

    void deleteRelationApps(Long strategyId, Long appId);

    PublishStrategyVO getPublishStrategyByAppId(Long appId) throws BizException;

    List<PublishStrategyResultVO> countHybridCloudPodNum(Deploy deploy) throws BizException;


}
