package cn.com.duiba.miria.publish.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;


@AdvancedFeignClient
public interface XmemcachedService {

    /**
     *  @param publishId
     * @param key
     * @param value
     * @param expireTime 过期时间，单位s 为0时表示永久储存
     */
    void setObject(Long publishId,String key, String value, int expireTime);

    /**
     *
     * @param key
     * @param value
     * @param expireTime 过期时间，单位s 为0时表示永久储存
     */
    void append(String key, String value, int expireTime);


    Object getObject(String key);

    Object delObj(String key);

    List<String> getPublishLog(String key);

    void setZipValue(String key, String value, int expireTime);

    List<String> getZipList(String key);

}
