package cn.com.duiba.miria.publish.api.remoteservice.bo;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.domain.params.DoPulishParams;
import cn.com.duiba.miria.publish.api.entity.Deploy;
import cn.com.duiba.miria.publish.api.entity.Publish;
import cn.com.duiba.sso.api.domain.dto.AdminDto;

@AdvancedFeignClient
public interface PublishBo {

    /**
     * 发布
     *
     * @param params
     * @return
     * @throws BizException
     **/
    Long doPublish(AdminDto publisher, DoPulishParams params) throws BizException;

    /**
     * 审核发布
     */
    void auditPublish(AdminDto adminDto, Long publishId, Integer status) throws BizException;


    /**
     * 回滚
     *
     * @param publishId
     * @return
     * @throws BizException
     */
    Long rollbackPublish(AdminDto publisher, Long publishId) throws BizException;

    /**
     * 找到堡垒机发布的镜像
     *
     * @param deploy
     * @return
     * @throws BizException
     */
    Publish getForTressDeployEndPublish(Deploy deploy) throws BizException;

    void cancelPublish(AdminDto publisher, Long publishId) throws BizException;

    void rollBackPrewContainer(Long adminId, Long publishId, Long deployId) throws BizException;

    void publishSso(String token) throws BizException;


}
