package cn.com.duiba.miria.publish.api.entity;

import java.util.Date;
import java.util.Objects;
import javax.persistence.*;

@Table(name = "tb_scene_test")
public class TbSceneTest {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 场景标识
     */
    @Column(name = "scene_name")
    private String sceneName;

    /**
     * 场景状态
     */
    private Integer state;

    /**
     * 发布者id
     */
    @Column(name = "admin_id")
    private Long adminId;

    @Column(name = "gmt_create")
    private Date gmtCreate;

    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 业务线
     */
    private String groups;

    /**
     * 发布应用状态集
     */
    @Column(name = "app_publish_info")
    private String appPublishInfo;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取场景标识
     *
     * @return scene_name - 场景标识
     */
    public String getSceneName() {
        return sceneName;
    }

    /**
     * 设置场景标识
     *
     * @param sceneName 场景标识
     */
    public void setSceneName(String sceneName) {
        this.sceneName = sceneName == null ? null : sceneName.trim();
    }

    /**
     * 获取场景状态
     *
     * @return state - 场景状态
     */
    public Integer getState() {
        return state;
    }

    /**
     * 设置场景状态
     *
     * @param state 场景状态
     */
    public void setState(Integer state) {
        this.state = state;
    }

    /**
     * 获取发布者id
     *
     * @return admin_id - 发布者id
     */
    public Long getAdminId() {
        return adminId;
    }

    /**
     * 设置发布者id
     *
     * @param adminId 发布者id
     */
    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    /**
     * @return gmt_create
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * @param gmtCreate
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * @return gmt_modified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * @param gmtModified
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * 获取业务线
     *
     * @return groups - 业务线
     */
    public String getGroups() {
        return groups;
    }

    /**
     * 设置业务线
     *
     * @param groups 业务线
     */
    public void setGroups(String groups) {
        this.groups = groups == null ? null : groups.trim();
    }

    /**
     * 获取发布应用状态集
     *
     * @return app_publish_info - 发布应用状态集
     */
    public String getAppPublishInfo() {
        return appPublishInfo;
    }

    /**
     * 设置发布应用状态集
     *
     * @param appPublishInfo 发布应用状态集
     */
    public void setAppPublishInfo(String appPublishInfo) {
        this.appPublishInfo = appPublishInfo == null ? null : appPublishInfo.trim();
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TbSceneTest that = (TbSceneTest) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}