package cn.com.duiba.miria.publish.api.enums;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.io.Serializable;
import java.util.Map;

@Getter
public enum SceneTestResultEnum implements Serializable {

    DOING(0,"发布中"),
    SUCCESS(1,"成功"),
    ERROR(2,"失败"),
    RELEASE(3,"销毁");

    private static Map<Integer, SceneTestResultEnum> MAP_CAHCE = Maps.newHashMap();
    static{
        for(SceneTestResultEnum resultEnum: SceneTestResultEnum.values()){
            MAP_CAHCE.put(resultEnum.getStateResult(),resultEnum);
        }
    }

    private Integer stateResult;
    private String name;

    SceneTestResultEnum(Integer stateResult, String name){
        this.stateResult = stateResult;
        this.name = name;
    }

    public static SceneTestResultEnum findByResult(Integer stateResult){
        return MAP_CAHCE.get(stateResult);
    }

}
