package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.entity.App;
import cn.com.duiba.miria.publish.api.domain.params.BranchCommit;
import org.gitlab.api.models.GitlabBranch;

import java.util.List;

@AdvancedFeignClient
public interface GitService {

    /**
     * @param app
     * @return gitlabBranches 返回branch列表  每个branch里面包含commit
     */
    List<GitlabBranch> getProjectBranch(App app) throws BizException;

    /**
     * @param app
     * @param branchName 分支名称
     * @return BranchCommit
     */
    BranchCommit getGitlabCommit(App app, String branchName) throws BizException;

}
