package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.entity.SceneTestApp;
import cn.com.duiba.miria.publish.api.entity.TbSceneTest;
import cn.com.duiba.miria.publish.api.vo.SceneTestVO;

import java.util.List;

@AdvancedFeignClient
public interface SceneTestService {
      /**
       * 发布场景
       * */
      void publishScene(Long adminId, String sceneName, List<SceneTestApp> sceneTestAppList) throws BizException;
      /**
       * 释放场景
       * */
      void releaseScene(Long adminId,Long sceneId) throws BizException;
      /**
       * 查询可见范围内的场景
       * */
      List<TbSceneTest> querySceneListByAdminId(Long adminId) throws BizException;
      /**
       * 根据场景id查询对应场景的详情
       * */
      SceneTestVO querySceneInfoById(Long sceneId) throws BizException;

}
