package cn.com.duiba.miria.publish.api.entity;

import java.util.Date;
import javax.persistence.*;

@Table(name = "tb_strategy_relation")
public class TbStrategyRelation {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 1.otherId为集群id，2otherId为应用id
     */
    @Column(name = "relation_type")
    private Integer relationType;

    @Column(name = "other_id")
    private Long otherId;

    @Column(name = "strategy_id")
    private Long strategyId;

    @Column(name = "modified_time")
    private Date modifiedTime;

    @Column(name = "created_time")
    private Date createdTime;

    /**
     * 关系类型为集群时表示权重
     */
    private Integer weight;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取1.otherId为集群id，2otherId为应用id
     *
     * @return relation_type - 1.otherId为集群id，2otherId为应用id
     */
    public Integer getRelationType() {
        return relationType;
    }

    /**
     * 设置1.otherId为集群id，2otherId为应用id
     *
     * @param relationType 1.otherId为集群id，2otherId为应用id
     */
    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    /**
     * @return other_id
     */
    public Long getOtherId() {
        return otherId;
    }

    /**
     * @param otherId
     */
    public void setOtherId(Long otherId) {
        this.otherId = otherId;
    }

    /**
     * @return strategy_id
     */
    public Long getStrategyId() {
        return strategyId;
    }

    /**
     * @param strategyId
     */
    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    /**
     * @return modified_time
     */
    public Date getModifiedTime() {
        return modifiedTime;
    }

    /**
     * @param modifiedTime
     */
    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    /**
     * @return created_time
     */
    public Date getCreatedTime() {
        return createdTime;
    }

    /**
     * @param createdTime
     */
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * 获取关系类型为集群时表示权重
     *
     * @return weight - 关系类型为集群时表示权重
     */
    public Integer getWeight() {
        return weight;
    }

    /**
     * 设置关系类型为集群时表示权重
     *
     * @param weight 关系类型为集群时表示权重
     */
    public void setWeight(Integer weight) {
        this.weight = weight;
    }
}