package cn.com.duiba.miria.publish.api.enums;

import lombok.Getter;

@Getter
public enum DeployPublishEnum {

    PERF_TEST(1, "压测", "perftest"), CONTAINER(0, "容器", "container");

    private Integer code;
    private String name;
    private String desc;

    DeployPublishEnum(Integer code, String name, String desc) {
        this.code = code;
        this.name = name;
        this.desc = desc;
    }

    public static DeployPublishEnum getByCode(Integer code){
        for(DeployPublishEnum deployPublishEnum:DeployPublishEnum.values()){
            if(deployPublishEnum.getCode().equals(code)){
                return deployPublishEnum;
            }
        }
        return null;
    }
}
