/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2018/2/25.
 **/
package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.entity.K8sProvider;

import java.util.List;


@AdvancedFeignClient
public interface K8sProviderService {

    void createProvider(K8sProvider k8sProvider) throws BizException;

    /**
     * 修改名称
     *
     * @param k8sProvider
     */
    void updateProviderInfo(K8sProvider k8sProvider) throws BizException;

    K8sProvider findSimpleProvider(Long id);

    List<K8sProvider> findByIds(List<Long> ids);

    List<K8sProvider> findAllProvider();
}

