package cn.com.duiba.miria.publish.api.entity;

import java.util.Date;
import javax.persistence.*;

@Table(name = "tb_container_start_info")
public class TbContainerStartInfo {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "created_time")
    private Date createdTime;

    @Column(name = "modified_time")
    private Date modifiedTime;

    /**
     * 启动状态 
     */
    private Integer state;

    /**
     * 关联publishId
     */
    @Column(name = "publish_id")
    private Long publishId;

    /**
     * 应用名称
     */
    @Column(name = "app_name")
    private String appName;

    /**
     * 发布分支
     */
    private String branch;

    /**
     * commit_id
     */
    @Column(name = "commit_id")
    private String commitId;

    /**
     * cpu
     */
    @Column(name = "cpu_core")
    private Float cpuCore;

    /**
     * memory
     */
    private Integer memory;

    private Integer quantity;

    /**
     * 注入环境变量
     */
    @Column(name = "env_variable")
    private String envVariable;

    /**
     * 关联外键id
     */
    @Column(name = "container_start_id")
    private Long containerStartId;

    /**
     * 绑定ip
     */
    @Column(name = "ip_hosts")
    private String ipHosts;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return created_time
     */
    public Date getCreatedTime() {
        return createdTime;
    }

    /**
     * @param createdTime
     */
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * @return modified_time
     */
    public Date getModifiedTime() {
        return modifiedTime;
    }

    /**
     * @param modifiedTime
     */
    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    /**
     * 获取启动状态 
     *
     * @return state - 启动状态 
     */
    public Integer getState() {
        return state;
    }

    /**
     * 设置启动状态 
     *
     * @param state 启动状态 
     */
    public void setState(Integer state) {
        this.state = state;
    }

    /**
     * 获取关联publishId
     *
     * @return publish_id - 关联publishId
     */
    public Long getPublishId() {
        return publishId;
    }

    /**
     * 设置关联publishId
     *
     * @param publishId 关联publishId
     */
    public void setPublishId(Long publishId) {
        this.publishId = publishId;
    }

    /**
     * 获取应用名称
     *
     * @return app_name - 应用名称
     */
    public String getAppName() {
        return appName;
    }

    /**
     * 设置应用名称
     *
     * @param appName 应用名称
     */
    public void setAppName(String appName) {
        this.appName = appName == null ? null : appName.trim();
    }

    /**
     * 获取发布分支
     *
     * @return branch - 发布分支
     */
    public String getBranch() {
        return branch;
    }

    /**
     * 设置发布分支
     *
     * @param branch 发布分支
     */
    public void setBranch(String branch) {
        this.branch = branch == null ? null : branch.trim();
    }

    /**
     * 获取commit_id
     *
     * @return commit_id - commit_id
     */
    public String getCommitId() {
        return commitId;
    }

    /**
     * 设置commit_id
     *
     * @param commitId commit_id
     */
    public void setCommitId(String commitId) {
        this.commitId = commitId == null ? null : commitId.trim();
    }

    /**
     * 获取cpu
     *
     * @return cpu_core - cpu
     */
    public Float getCpuCore() {
        return cpuCore;
    }

    /**
     * 设置cpu
     *
     * @param cpuCore cpu
     */
    public void setCpuCore(Float cpuCore) {
        this.cpuCore = cpuCore;
    }

    /**
     * 获取memory
     *
     * @return memory - memory
     */
    public Integer getMemory() {
        return memory;
    }

    /**
     * 设置memory
     *
     * @param memory memory
     */
    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    /**
     * @return quantity
     */
    public Integer getQuantity() {
        return quantity;
    }

    /**
     * @param quantity
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    /**
     * 获取注入环境变量
     *
     * @return env_variable - 注入环境变量
     */
    public String getEnvVariable() {
        return envVariable;
    }

    /**
     * 设置注入环境变量
     *
     * @param envVariable 注入环境变量
     */
    public void setEnvVariable(String envVariable) {
        this.envVariable = envVariable == null ? null : envVariable.trim();
    }

    /**
     * 获取关联外键id
     *
     * @return container_start_id - 关联外键id
     */
    public Long getContainerStartId() {
        return containerStartId;
    }

    /**
     * 设置关联外键id
     *
     * @param containerStartId 关联外键id
     */
    public void setContainerStartId(Long containerStartId) {
        this.containerStartId = containerStartId;
    }

    /**
     * 获取绑定ip
     *
     * @return ip_hosts - 绑定ip
     */
    public String getIpHosts() {
        return ipHosts;
    }

    /**
     * 设置绑定ip
     *
     * @param ipHosts 绑定ip
     */
    public void setIpHosts(String ipHosts) {
        this.ipHosts = ipHosts == null ? null : ipHosts.trim();
    }
}