/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2017/12/15.
 **/
package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.entity.Cloud;

import java.util.List;
import java.util.Map;


@AdvancedFeignClient
public interface CloudService {

    Integer createCloud(Cloud cloud) throws BizException;

    /**
     * 更新名称和描述
     *
     * @param cloud
     * @return
     */
    Integer updateCloud(Cloud cloud) throws BizException;

    Cloud find(Long cloudId);

    /**
     * 获取
     *
     * @return
     */
    List<Cloud> listAllCloud();

    Map<Long, Cloud> cloudMap();

    /**
     * 获取阿里云  取第一个
     * */
    Cloud getDefaultCloud();
}
