package cn.com.duiba.miria.publish.api.constant;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import lombok.Getter;

import java.util.List;
@Getter
public enum CacheKeyEnum {

    MIRIA_DEPLAY_STATE("MIRIA_DEPLAY_STATE","每个应用部署的的当前状态");

    private static Joiner joiner = Joiner.on("_").skipNulls();

    CacheKeyEnum(String preKey,String description){
        this.preKey = preKey;
        this.description = description;
    }

    private String preKey;
    private String description;


    public String getCacheKey(Object ...bizId){
        List<String> bizIds = Lists.newArrayList(this.preKey);
        for(Object biz:bizId){
            bizIds.add(biz.toString());
        }
        return joiner.join(bizIds);
    }

}
