package cn.com.duiba.miria.publish.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
@Data
public class StartContainerInfoDto implements Serializable {


    private static final long serialVersionUID = 9022314782066148844L;
    /**
     * 应用名称,not null
     * */
    private String appName;
    /**
    * 分支名称  可为空,为空默认为master
    */
    private String branch;
    /**
      * git提交码  暂时未支持基于commitId的发布
      */
    private String commitId;
    /**
     * cpu核数, not null
     * */
    private Integer      cpuCore;
    /**
     * 内存数量 单位G, not null
     * */
    private Integer      memory;
    /**
     * 容器数量, not null
     * */
    private Integer      quantity;
    /**
     *  每一行 ip domain
     *  */
    private List<HostDto> hostDtos;
    /**
     * 环境变量 not null
     * */
    private List<EnvVariableDto> envVariableDtos;


}
