package cn.com.duiba.miria.publish.api.entity;

import java.util.Date;
import javax.persistence.*;

@Table(name = "tb_auto_test_group")
public class TbAutoTestGroup {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 自动化测试任务名称
     */
    @Column(name = "job_name")
    private String jobName;

    @Column(name = "gmt_create")
    private Date gmtCreate;

    @Column(name = "gmt_modified")
    private Date gmtModified;

    @Column(name = "admin_id")
    private Long adminId;

    @Column(name = "over_time")
    private Integer overTime;

    @Column(name = "enable_hotfix")
    private Boolean enableHotfix;

    private String groups;

    private Integer state;

    @Column(name = "publish_id")
    private Long publishId;

    @Column(name = "ding_token")
    private String dingToken;

    /**
     * 自动化测试关联jenkinsId
     */
    @Column(name = "jenkins_id")
    private Long jenkinsId;

    /**
     * 禁用状态
     */
    private Boolean disabled;

    @Column(name = "app_info")
    private String appInfo;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取自动化测试任务名称
     *
     * @return job_name - 自动化测试任务名称
     */
    public String getJobName() {
        return jobName;
    }

    /**
     * 设置自动化测试任务名称
     *
     * @param jobName 自动化测试任务名称
     */
    public void setJobName(String jobName) {
        this.jobName = jobName == null ? null : jobName.trim();
    }

    /**
     * @return gmt_create
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * @param gmtCreate
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * @return gmt_modified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * @param gmtModified
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * @return admin_id
     */
    public Long getAdminId() {
        return adminId;
    }

    /**
     * @param adminId
     */
    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    /**
     * @return over_time
     */
    public Integer getOverTime() {
        return overTime;
    }

    /**
     * @param overTime
     */
    public void setOverTime(Integer overTime) {
        this.overTime = overTime;
    }

    /**
     * @return enable_hotfix
     */
    public Boolean getEnableHotfix() {
        return enableHotfix;
    }

    /**
     * @param enableHotfix
     */
    public void setEnableHotfix(Boolean enableHotfix) {
        this.enableHotfix = enableHotfix;
    }

    /**
     * @return groups
     */
    public String getGroups() {
        return groups;
    }

    /**
     * @param groups
     */
    public void setGroups(String groups) {
        this.groups = groups == null ? null : groups.trim();
    }

    /**
     * @return state
     */
    public Integer getState() {
        return state;
    }

    /**
     * @param state
     */
    public void setState(Integer state) {
        this.state = state;
    }

    /**
     * @return publish_id
     */
    public Long getPublishId() {
        return publishId;
    }

    /**
     * @param publishId
     */
    public void setPublishId(Long publishId) {
        this.publishId = publishId;
    }

    /**
     * @return ding_token
     */
    public String getDingToken() {
        return dingToken;
    }

    /**
     * @param dingToken
     */
    public void setDingToken(String dingToken) {
        this.dingToken = dingToken == null ? null : dingToken.trim();
    }

    /**
     * 获取自动化测试关联jenkinsId
     *
     * @return jenkins_id - 自动化测试关联jenkinsId
     */
    public Long getJenkinsId() {
        return jenkinsId;
    }

    /**
     * 设置自动化测试关联jenkinsId
     *
     * @param jenkinsId 自动化测试关联jenkinsId
     */
    public void setJenkinsId(Long jenkinsId) {
        this.jenkinsId = jenkinsId;
    }

    /**
     * 获取禁用状态
     *
     * @return disabled - 禁用状态
     */
    public Boolean getDisabled() {
        return disabled;
    }

    /**
     * 设置禁用状态
     *
     * @param disabled 禁用状态
     */
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    /**
     * @return app_info
     */
    public String getAppInfo() {
        return appInfo;
    }

    /**
     * @param appInfo
     */
    public void setAppInfo(String appInfo) {
        this.appInfo = appInfo == null ? null : appInfo.trim();
    }
}