package cn.com.duiba.miria.publish.api.entity;

import java.util.Date;
import javax.persistence.*;

@Table(name = "tb_container_starts")
public class TbContainerStarts {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 该次启动容器业务对应在数据库的唯一建
     */
    @Column(name = "start_key")
    private Long startKey;

    /**
     * 该次启动容器业务的类型
     */
    @Column(name = "start_type")
    private String startType;

    @Column(name = "created_time")
    private Date createdTime;

    @Column(name = "modified_time")
    private Date modifiedTime;

    /**
     * 启动状态 0:启动中 1：正常 2:销毁 3：启动失败
     */
    private Integer state;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取该次启动容器业务对应在数据库的唯一建
     *
     * @return start_key - 该次启动容器业务对应在数据库的唯一建
     */
    public Long getStartKey() {
        return startKey;
    }

    /**
     * 设置该次启动容器业务对应在数据库的唯一建
     *
     * @param startKey 该次启动容器业务对应在数据库的唯一建
     */
    public void setStartKey(Long startKey) {
        this.startKey = startKey;
    }

    /**
     * 获取该次启动容器业务的类型
     *
     * @return start_type - 该次启动容器业务的类型
     */
    public String getStartType() {
        return startType;
    }

    /**
     * 设置该次启动容器业务的类型
     *
     * @param startType 该次启动容器业务的类型
     */
    public void setStartType(String startType) {
        this.startType = startType == null ? null : startType.trim();
    }

    /**
     * @return created_time
     */
    public Date getCreatedTime() {
        return createdTime;
    }

    /**
     * @param createdTime
     */
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * @return modified_time
     */
    public Date getModifiedTime() {
        return modifiedTime;
    }

    /**
     * @param modifiedTime
     */
    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    /**
     * 获取启动状态 0:启动中 1：正常 2:销毁 3：启动失败
     *
     * @return state - 启动状态 0:启动中 1：正常 2:销毁 3：启动失败
     */
    public Integer getState() {
        return state;
    }

    /**
     * 设置启动状态 0:启动中 1：正常 2:销毁 3：启动失败
     *
     * @param state 启动状态 0:启动中 1：正常 2:销毁 3：启动失败
     */
    public void setState(Integer state) {
        this.state = state;
    }
}