package cn.com.duiba.miria.publish.api.enums;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.util.Map;
@Getter
public enum DeploymentTypeEnum {
    CONTAINER(0,"容器","CONTAINER"),
    VM(1,"VM","VM"),
    CONTAINER_VM(2,"容器/VM","CONTAINER/VM");


    private static Map<Integer,DeploymentTypeEnum> MAP = Maps.newHashMap();
    static {
        for(DeploymentTypeEnum deploymentTypeEnum:DeploymentTypeEnum.values()){
            MAP.put(deploymentTypeEnum.getCode(),deploymentTypeEnum);
        }
    }

    DeploymentTypeEnum(Integer code,String name,String description){
        this.code = code;
        this.name = name;
        this.description = description;
    }

    private Integer code;
    private String name;
    private String description;

    public static DeploymentTypeEnum findByCode(Integer state){
        return MAP.get(state);
    }
}
