/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2017/12/15.
 **/
package cn.com.duiba.miria.publish.api.domain.vo;

import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;
import java.util.Map;
import java.util.Set;

@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
public class PublishArgsVO {

    private String appName;

    private Long deployId;

    private String namespace;

    private Set<Integer> portSet;

    private String imagePath;

    private String protocol = "TCP";

    private List<String> command;

    private List<String> args;

    private List<EnvVar> env;

    private ResourceRequirements resources;

    private int instanceNum;

    private Map<String, String> nodeSelector;

    private Probe livenessProbe;

}
