package cn.com.duiba.miria.publish.api.entity;

import java.util.Date;
import javax.persistence.*;

@Table(name = "tb_publish_together")
public class PublishTogether {
    /**
     * 逻辑主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 主题
     */
    private String theme;

    /**
     * 定时任务表达式
     */
    private String cron;

    /**
     * 关联的应用和分支信息
     */
    @Column(name = "app_list")
    private String appList;

    /**
     * 关联的自动化任务id列表
     */
    @Column(name = "job_id_list")
    private String jobIdList;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 获取逻辑主键
     *
     * @return id - 逻辑主键
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置逻辑主键
     *
     * @param id 逻辑主键
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取主题
     *
     * @return theme - 主题
     */
    public String getTheme() {
        return theme;
    }

    /**
     * 设置主题
     *
     * @param theme 主题
     */
    public void setTheme(String theme) {
        this.theme = theme == null ? null : theme.trim();
    }

    /**
     * 获取定时任务表达式
     *
     * @return cron - 定时任务表达式
     */
    public String getCron() {
        return cron;
    }

    /**
     * 设置定时任务表达式
     *
     * @param cron 定时任务表达式
     */
    public void setCron(String cron) {
        this.cron = cron == null ? null : cron.trim();
    }

    /**
     * 获取关联的应用和分支信息
     *
     * @return app_list - 关联的应用和分支信息
     */
    public String getAppList() {
        return appList;
    }

    /**
     * 设置关联的应用和分支信息
     *
     * @param appList 关联的应用和分支信息
     */
    public void setAppList(String appList) {
        this.appList = appList == null ? null : appList.trim();
    }

    /**
     * 获取关联的自动化任务id列表
     *
     * @return job_id_list - 关联的自动化任务id列表
     */
    public String getJobIdList() {
        return jobIdList;
    }

    /**
     * 设置关联的自动化任务id列表
     *
     * @param jobIdList 关联的自动化任务id列表
     */
    public void setJobIdList(String jobIdList) {
        this.jobIdList = jobIdList == null ? null : jobIdList.trim();
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}