package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.vo.PublishTogetherVO;

import java.util.List;

/**
 * 聚合发布远端服务
 */
@AdvancedFeignClient
public interface RemotePublishTogetherService {

    /**
     * @return 汇总发布列表
     */
    List<PublishTogetherVO> queryList();

    /**
     * @param publishTogetherVO 新增或者修改的参数信息
     */
    void addOrModify(PublishTogetherVO publishTogetherVO) throws BizException;

    /**
     * 根据id汇总发布
     *
     * @param id 主键id
     */
    void publish(Long adminId, Long id) throws BizException;

    /**
     * 重新发布某个应用
     *
     * @param adminId 用户id
     * @param id      配置id
     * @param appName   应用名
     * @throws BizException 业务异常
     */
    void rePublishApp(Long adminId, Long id, String appName) throws BizException;
}
