package cn.com.duiba.miria.publish.api.enums;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.io.Serializable;
import java.util.Map;

@Getter
public enum AutoTestResultEnum implements Serializable {

    NORMAL(1,"正常"),
    PUBLISH(2,"发布中"),
    TEST(3,"测试中"),
    TEST_TIMEOUT(4,"测试超时");

    private static Map<Integer, AutoTestResultEnum> MAP_CAHCE = Maps.newHashMap();
    static{
        for(AutoTestResultEnum resultEnum: AutoTestResultEnum.values()){
            MAP_CAHCE.put(resultEnum.getStateResult(),resultEnum);
        }
    }

    private Integer stateResult;
    private String name;

    AutoTestResultEnum(Integer stateResult, String name){
        this.stateResult = stateResult;
        this.name = name;
    }

    public static AutoTestResultEnum findByResult(Integer stateResult){
        return MAP_CAHCE.get(stateResult);
    }

}
