package cn.com.duiba.miria.publish.api.enums;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.util.Map;
@Getter
public enum  ContainerStartTypeEnum {

    FLOW_REPLAY(1,"flowReplay","引流回归");


    private static Map<String,ContainerStartTypeEnum> map = Maps.newHashMap();
    static {
        for(ContainerStartTypeEnum deploymentTypeEnum:ContainerStartTypeEnum.values()){
            map.put(deploymentTypeEnum.getName(),deploymentTypeEnum);
        }
    }

    ContainerStartTypeEnum(Integer code,String name,String description){
        this.code = code;
        this.name = name;
        this.description = description;
    }

    private Integer code;
    private String name;
    private String description;

    public static ContainerStartTypeEnum getByCode(Integer code){

        for(ContainerStartTypeEnum containerStartTypeEnum:ContainerStartTypeEnum.values()){
            if(containerStartTypeEnum.code.equals(code)){
                return  containerStartTypeEnum;
            }
        }

        return null;
    }

    public static ContainerStartTypeEnum getByName(String name){
        return map.get(name);
    }


}
