package cn.com.duiba.miria.publish.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.entity.App;
import cn.com.duiba.miria.publish.api.entity.Deploy;
import cn.com.duiba.miria.publish.api.entity.Publish;
import cn.com.duiba.miria.publish.api.enums.DeployPublishEnum;
import io.fabric8.kubernetes.api.model.*;

import java.util.List;

@AdvancedFeignClient
public interface KubernetesService {


    ResourceRequirements buildResourceRequirements(Deploy deploy);

    /**
     * 心跳监测
     */
    Probe buildLivenessProbe(App app);

    /**
     * 解析命令
     *
     * @param publish
     * @return
     */
    List<String> getCommandList(Publish publish);

    /**
     * 解析参数
     *
     * @param publish
     * @return
     */
    List<String> getArgsList(Publish publish);

    /**
     * 解析环境参数
     *
     * @param publish
     * @return
     **/
    List<EnvVar> getEnvVarsList(Deploy deploy,Publish publish, App app, Long envId);

    List<EnvFromSource> getEnvFrom(Deploy deploy);

    List<VolumeMount> getVolumeMountListFromDB(long appId, long envId);

    List<VolumeMount> getVolumeMountList();

    List<Volume> getVolumeList(long appId, long envId);


}
