package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.dto.AppDeployBranchDto;
import cn.com.duiba.miria.publish.api.dto.StartContainerInfoDto;
import cn.com.duiba.miria.publish.api.dto.StartUpResultDto;

import java.util.ArrayList;
import java.util.List;


@AdvancedFeignClient
public interface RemoteContainerStartService {

    /**
     * 启动容器
     *
     * @param startContainerInfoDtos 启动容器集合
     * @param key                    该次启动容器业务对应在数据库的唯一建
     * @param type                   该次启动容器业务的类型  1.引流回归测试 ContainerStartTypeEnum.code
     * @throws BizException
     */
    void startUp(List<StartContainerInfoDto> startContainerInfoDtos,Long key,Integer type,Long adminId) throws BizException;

    /**
     * 启动结果查询
     * * @param key
     *
     * @param type
     * @throws BizException
     */
    StartUpResultDto queryStartUpResult(Long key,Integer type) throws BizException;

    /**
     * 释放资源
     * 容器平台收到该请求后，需要异步操作释放资源操作，并保证资源的释放，该请求直接响应ok
     *
     * @param key
     * @param type
     * @throws BizException
     */
    void release(Long key,Integer type) throws BizException;

    void createIdcNetWorkPolicy(Long key,Integer type,String appName,List<String> ipList) throws BizException;

    List<String> queryContainerIpByAppNameAndType(Long key,Integer type,String appName) throws BizException;

    AppDeployBranchDto queryAppDeployBranch(String appName) throws BizException;


}
