package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.entity.AppDeployConfig;
import cn.com.duiba.miria.publish.api.perftest.PerfTestContainersDto;
import cn.com.duiba.miria.publish.api.perftest.PerfTestStartUpResultDto;

import java.util.List;

/**
 * 为压测平台提供接口类
 */

@AdvancedFeignClient
public interface RemotePerfTestService {

    /**
     * 启动容器
     * <p>
     * 压测启动，调用容器平台启动相关容器
     * 容器平台需要把创建的这一批容器和sceneId关联起来。后续释放资源的时候需要用到
     * 所有启动的容器（含施压机和被压机）中，都需要加一个环境变量，duiba.perf.test.sceneId=xxx，值为body中的sceneId的值
     * <p>
     * 启动之前判断
     * 如果本次请求的sceneId存在未释放的容器，则不给启动，并抛BizException异常
     * 其他已知可能发生的问题，也抛BizException异常
     * 如果可以正常启动，则异步启动
     * <p>
     * 注意：先存储sceneId和容器的关联关系，再进行容器的启动
     *
     * @param perfTestContainersDto
     * @throws BizException 错误类型：1.施压机被压机参数非空校验 2.施压机未录入 3.施压机未部署 4.无效的serviceId:xxx 5.sceneId:场景下存在未释放的容器 6.未能找到被压机xxx的对应镜像
     */
    void startUp(PerfTestContainersDto perfTestContainersDto) throws BizException;

    /**
     * 启动结果查询
     * <p>
     * 查询场景对应的一批容器的启动情况
     * 每个场景，压测平台会间隔5秒轮询一次
     * <p>
     * 如果本次请求的sceneId并没有发送过启动请求过来，则抛BizException异常，说明“非法的调用（sceneId无效）”
     *
     * @param sceneId
     * @return
     * @throws BizException 错误类型：1.无效的sceneId:xxx
     */
    PerfTestStartUpResultDto queryStartUpResult(Long sceneId) throws BizException;

    /**
     * 释放资源
     * <p>
     * 容器平台收到该请求后，需要异步操作释放资源操作，并保证资源的释放，该请求直接响应ok
     * <p>
     * 如果本次请求的sceneId并没有发送过启动请求过来，则抛BizException异常，说明“非法的调用（sceneId无效）”
     *
     * @param sceneId
     * @return
     * @throws BizException 错误类型：1.无效的sceneId:xxx 2.销毁失败
     */
    void release(Long sceneId) throws BizException;

    /**
     * 根据应用名查询应用的配置和应用的台数
     *
     * @param appNames 应用名list
     * @return 应用的配置和应用的台数
     */
    List<AppDeployConfig> getAppDeployConfigs(List<String> appNames) throws BizException;

}
