package cn.com.duiba.miria.publish.api.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

@Data
public class JenkinsBuildVO implements Serializable {
    private static final long serialVersionUID = 535569972156132614L;

    private String gitBranch;

    private String gitUrl;

    private String appName;

    private String imageCenterUrl;

    private String imageCenterPassword;

    private Integer cacheNum;

    private String commitId;

    public String getTag(String commitId, Integer jobId) {
        return commitId + "_" + jobId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        JenkinsBuildVO that = (JenkinsBuildVO) o;
        return Objects.equals(gitBranch, that.gitBranch) &&
                Objects.equals(appName, that.appName) &&
                Objects.equals(commitId, that.commitId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(gitBranch, appName, commitId);
    }

}
